ORRCSIG ;SLC/MKB - Signature utilities for CM ; 25 Jul 2003  9:31 AM
 ;;1.0;CARE MANAGEMENT;;Jul 15, 2003
 ;
 ; ID = "DOC:"_Document# or "ORU:"_Order# everywhere below
 ;
LIST(ORY,ORUSR,ORPAT,ORDET) ; -- Return unsigned orders and documents by ORUSR for ORPAT
 ; in @ORY@(#) = Item=ID^Text^Date in HL7 format, and also if ORDET
 ;             = Text=line of report text
 ; RPC = ORRC UNSIGNED BY PATIENT
 N ORN,ORI,ORORD,ORDOC
 S ORUSR=+$G(ORUSR),ORPAT=+$G(ORPAT)
 D LISTUNS^ORRCOR(.ORORD,ORUSR,ORPAT,$G(ORDET))
 D LISTUNS^ORRCTIU(.ORDOC,ORUSR,ORPAT,$G(ORDET))
 S ORY=$NA(^TMP($J,"ORRCSIG")),ORN=0 K @ORY
 S ORI=0 F  S ORI=$O(@ORORD@(ORI)) Q:ORI<1  S ORN=ORN+1,@ORY@(ORN)=@ORORD@(ORI)
 S ORI=0 F  S ORI=$O(@ORDOC@(ORI)) Q:ORI<1  S ORN=ORN+1,@ORY@(ORN)=@ORDOC@(ORI)
 K @ORORD,@ORDOC
 Q
 ;
DETAIL(ORY,ITEM) ; -- Return details of unsigned ITEMs
 ; where ITEM(#) = ID
 ;   in @ORY@(#) = Item=ID^Text^Date in HL7 format
 ;               = Text=line of report text
 ; RPC = ORRC UNSIGNED BY ID
 N ORN,ORI,ORID,ORO,ORD,ORORD,ORDOC
 S ORI="" F  S ORI=$O(ITEM(ORI)) Q:ORI=""  S ORID=ITEM(ORI) D
 . I ORID["OR" S ORO(ORI)=ORID
 . I ORID["DOC" S ORD(ORI)=ORID
 D DETAIL^ORRCOR(.ORORD,.ORO),TEXT^ORRCTIU(.ORDOC,.ORD)
 S ORY=$NA(^TMP($J,"ORRCSIG")),ORN=0 K @ORY
 S ORI=0 F  S ORI=$O(@ORORD@(ORI)) Q:ORI<1  S ORN=ORN+1,@ORY@(ORN)=@ORORD@(ORI)
 S ORI=0 F  S ORI=$O(@ORDOC@(ORI)) Q:ORI<1  S ORN=ORN+1,@ORY@(ORN)=@ORDOC@(ORI)
 K @ORORD,@ORDOC
 Q
 ;
SIGN(ORY,ORNP,LOC,ESCODE,ITEM) ; -- Apply signature to ITEMs
 ; where ITEM(#) = ID for notes, or for orders
 ;               = ID^DFN^Release Flag^Signature Status^Nature of Order
 ;   in @ORY@(#) = ID^Success Indicator^Error Message (if 'Success)
 ; RPC = ORRC SIGN ITEMS
 N ORN,DFN,ORID,ORO,ORD,ORORD,ORDOC
 S ORI="" F  S ORI=$O(ITEM(ORI)) Q:ORI=""  D
 . S ORID=$P(ITEM(ORI),U)
 . I ORID["OR" S ORO(ORI)=$P(ORID,":",2)_U_$P(ITEM(ORI),U,2,5)
 . I ORID["DOC" D
 . . N ERROR
 . . D SIGN^TIUSRVP(.ERROR,$P(ORID,":",2),ESCODE)
 . . S ORDOC(ORI)=ORID_U_'+ERROR_$P(ERROR,U,2)
 I $D(ORO) D SIGNORDR(.ORORD,ORNP,LOC,.ORO)
 S ORY=$NA(^TMP($J,"ORRCSIG")),ORN=0 K @ORY
 S ORI=0 F  S ORI=$O(ORORD(ORI)) Q:ORI<1  S ORN=ORN+1,@ORY@(ORN)=ORORD(ORI)
 S ORI=0 F  S ORI=$O(ORDOC(ORI)) Q:ORI<1  S ORN=ORN+1,@ORY@(ORN)=ORDOC(ORI)
 Q
SIGNORDR(ORORD,ORNP,LOC,ORO)    ; Sign orders
 N OROBYPT,DFN,OREI,ORNDX,ORERRS
 D SORTORDR(.ORBYPT,.ORO),INDEX(.ORNDX,.ORO,.ORORD)
 S DFN=0 F  S DFN=$O(ORBYPT(DFN)) Q:+DFN'>0  D
 . N ORLST M ORLST=ORBYPT(DFN)
 . ;D SIGN^ORWD(.ORERRS,DFN,ORNP,LOC,.ORLST)
 S OREI=0 F  S OREI=$O(ORERRS(OREI)) Q:+OREI'>0  D
 . N ORID,ORI S ORID=$P(ORERRS(OREI),U),ORI=$G(ORNDX(ORID))
 . I +ORI S ORORD(ORI)=ORID_U_0_U_$P(ORERRS(OREI),U,2)
 Q
TSTSORT ; Test SORTORDR and INDEX calls
 N ORO,ORI,ORBYPT,ORNDX,ORORD
 S ORO(1)="123^987^1^U^E"
 S ORO(3)="176^789^1^U^E"
 S ORO(5)="221^987^1^U^E"
 S ORO(6)="233^321^1^U^E"
 S ORO(9)="311^789^1^U^E"
 S ORO(15)="339^321^1^U^E"
 ;W ! S ORI=0 F  S ORI=$O(ORO(ORI)) Q:+ORI'>0  D
 ;. W !,"ORO(",ORI,")=",ORO(ORI)
 ;D SORTORDR(.ORBYPT,.ORO),INDEX(.ORNDX,.ORO,.ORORD)
 ;W ! ZW ORBYPT W ! ZW ORNDX W ! ZW ORORD
 Q
SORTORDR(ORBYPT,ORO)    ; Sort orders by patient
 N ORI S ORI=0
 F  S ORI=$O(ORO(ORI)) Q:+ORI'>0  D
 . N ORDER,DFN,ID S ORDER=ORO(ORI),DFN=$P(ORDER,U,2),ID=$P(ORDER,U)
 . S ORBYPT(DFN,ORI)=ID_U_$P(ORDER,U,3,5)
 Q
INDEX(ORNDX,ORO,ORORD)  ; Index orders
 N ORI S ORI=0
 F  S ORI=$O(ORO(ORI)) Q:+ORI'>0  D
 . N ORID S ORID=$P(ORO(ORI),U)
 . S ORNDX(ORID)=ORI,ORORD(ORI)=ORID_U_1
 Q
